<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMember;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssignmentCommittee extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table = 'assignment_committees';

    protected $guarded = [];

    public function committee()
    {
        return $this->belongsTo(Committee::class);
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function CommitteeMember()
    {
        return $this->hasMany(CommitteeMember::class,'assignment_committee_id');
    }
}
