<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class GuideRegulationFile extends Model
{
    use SoftDeletes;

    protected $table='guides_and_regulations_files';

    protected function filePath(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => isset($value) ? Helper::uploadedFilesPath('guidesRegulations',$value) : null,
        );
    }

    public function guideRegulation() {
        return $this->belongsTo(GuideRegulation::class);
    }
}
