<?php

namespace App\Models\AdminDashboard\School;

use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommitteeData;
use Illuminate\Database\Eloquent\Model;
use App\Models\ManagerDashboard\TeacherSchedule;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class SchoolClass extends Model
{
    use HasFactory;

    protected $table= 'school_classes';
    protected $guarded= [];
    public $timestamps = false;

    // public function teacherSchedule()
    // {
    //     return $this->hasOne(TeacherSchedule::class, 'school_class_id','id');
    // }

    public function className(){
        return $this->belongsTo(ClassName::class,'class_name_id')->with('grade');
    }

    public function Students(){
        return $this->hasMany(Student::class,'class_id');
    }

    public function studentCommittees()
    {
        return $this->hasMany(StudentCommittee::class, 'schoolclass_id');
    }


    public function studentCommitteesData()
    {
        return $this->hasMany(StudentCommitteeData::class, 'schoolclass_id');
    }

}
