<?php

namespace App\Models\AdminDashboard\School;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;
class ClassName extends Model
{
    use SoftDeletes;

    protected $table= 'class_names';
    protected $guarded= [];


    public function grade(){
        return $this->belongsTo(SchoolGrade::class,'school_grade_id');
    }
    
    public function schoolClasses(){
        return $this->hasMany(SchoolClass::class,'class_name_id');
    }

    public function getLevelNumberAttribute()
{
    // يحاول يطلع أول رقم موجود في الاسم (زي "أولى" -> 1)
    if (preg_match('/\d+/', $this->name, $matches)) {
        return (int) $matches[0];
    }

    // أو لو الاسم بالعربي (أولى، ثانية...) نستخدم تحويل يدوي
    $map = [
        'الأول' => 1,
        'الثاني' => 2,
        'الثالث' => 3,
        'الرابع' => 4,
        'الخامس' => 5,
        'السادس' => 6,
    ];

    foreach ($map as $word => $num) {
        if (Str::contains($this->name, $word)) {
            return $num;
        }
    }

    return null; // لو مفيش رقم معروف
}
}
