<?php

namespace App\Jobs;

use App\Traits\SmsTrait;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendSMSNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels,SmsTrait;

    protected $phone;
    protected $message;
    protected $managerId;

    /**
     * Create a new job instance.
     */
    public function __construct($phone, $message, $managerId)
    {
        $this->phone = $phone;
        $this->message = $message;
        $this->managerId = $managerId;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        // Replace with your actual SMS sending logic
        static::sendSMSNotification($this->phone, $this->message, $this->managerId);
    }
}
