<?php

namespace App\Jobs;

use App\Mail\RegisteredSchoolEmployeeMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $school_employee;

    public function __construct($school_employee)
    {
        $this->school_employee = $school_employee;
    }

    public function handle()
    {
        // Send the email
        Mail::to($this->school_employee->email)->send(new RegisteredSchoolEmployeeMail($this->school_employee));
    }
}

