<?php
namespace App\Imports;

use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\IOFactory;

class TeachersImport implements WithMultipleSheets
{
    protected $file;
    protected $skipRows;
    protected $schoolId;

    public function __construct($file, array $skipRows = [],$schoolId)
    {
        $this->file = $file;
        $this->skipRows = $skipRows;
        $this->schoolId = $schoolId;
    }

    public function sheets(): array
    {
        $spreadsheet = IOFactory::load($this->file->getPathname());
        $sheetNames = $spreadsheet->getSheetNames();

        $sheetImports = [];
        foreach ($sheetNames as $sheetName) {
            $sheetImports[$sheetName] = new TeacherBaseImport($this->file,$this->skipRows,$this->schoolId);
        }
        return $sheetImports;
    }
}
