<?php
namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Helpers\Helper;

class TeacherBaseImport implements ToCollection,WithHeadingRow
{
    protected $file;
    protected $skipRows;
    protected $schoolId;

    public function __construct($file,array $skipRows = [],$schoolId)
    {
        $this->file = $file;
        $this->skipRows = $skipRows;
        $this->schoolId = $schoolId;
    }

    public function collection(Collection $rows){
        $filteredRows = $rows->filter(function ($row, $index) {
            // Skip row if it is in the skip list (index starts from 1 including heading row)
            return !in_array($index , $this->skipRows);
        });

        /** add School Teachers */
        foreach ($filteredRows as $row) {
            if(is_numeric($row[23])){
                SchoolEmployee::create([
                    'name' => $row[21],
                    'ssn' => $row[23],
                    'email' => $row[8],
                    'phone' => Helper::formatPhoneNumber($row[5]),
                    'type' => 'teacher',
                    'current_work_id' =>2,
                    'specialization_id' => NULL,
                    'school_id' => $this->schoolId,
                    'have_account'=>'yes',
                    'current_school_year' => Helper::getSchoolYear(),
                ]);
            }
        }
    }
}

