<?php

namespace App\Http\Resources\User;

use App\Http\Resources\School\SchoolResource;
use App\Models\AdminDashboard\School\School;
use App\Models\User;
use App\Models\AdminDashboard\School\SchoolEmployee;

use Illuminate\Http\Resources\Json\JsonResource;
class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $user= User::find($this->id);
        $roles = $user->roles->pluck('name', 'id')->toArray();
        $userTypes=  explode(',', $this->user_type);

        if(in_array('super_admin',$userTypes)){
            $userSchools = SchoolResource::collection(School::where('id',1)->get());
        }else{
            $schoolIds = SchoolEmployee::where('user_id',$this->id)->pluck('school_id')->toArray();
            $userSchools = SchoolResource::collection(School::whereIn('id',$schoolIds)->get());
        }

        // Translate role names based on the requested language
        $rolesNames=[];
        foreach ($roles as $key => $roleName) {
            // Translate role names using the lang file, default to English if not found
            $rolesNames[$key] = __('api.' . $roleName, [], 'ar');
        }

        $data=[
            'user_id'=>$this->id,
            'name' =>$this->name,
            'email'=>$this->email,
            'phone'=>$this->phone,
            'image'=>($this->image)?public_path('/users/'.$this->image):'image not foud !',
            'phone' =>$this->phone,
            'status'=>$this->status,
            'password_reseted'=>$this->password_reseted,
            'user_type'=>$userTypes,
            'roles'=>$roles,
            'roles_names'=>$rolesNames,
        ];


        $data['userSchools']=$userSchools;

        return $data;
    }
}
