<?php

namespace App\Http\Resources\User;
use Spatie\Permission\Models\Role;
use App\Http\Resources\User\PermissionResource;
use Spatie\Permission\Models\Permission;
use Illuminate\Http\Resources\Json\JsonResource;

class RoleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'name' =>$this->name,
            'rolePermissions'=>$this->getPermissions($this->id),
            'created_at'=>$this->created_at->format('d/m/Y')
        ];
    }


    public function getPermissions($roleId){
        $role = Role::find($roleId);

        if (!$role) {
            return response()->json(['message' => 'Role not found'], 404);
        }

        $permissions = Permission::where('type', 'super_admin')->get();
        $rolePermissions = $role->permissions;

        $intersectedPermissions = $permissions->map(function ($permission) use ($rolePermissions) {
            $isIntersected = $rolePermissions->contains('id', $permission->id);
            $subPermissions = $this->getSubPermissions($permission->id, $rolePermissions);

            if ($isIntersected || !empty($subPermissions)) {
                return [
                    'id' => $permission->id,
                    'name' => $permission->name,
                    'name_ar' => $permission->name_ar,
                    'is_intersected' => $isIntersected,
                    'sub_permissions' => $subPermissions,
                ];
            }

            return null;
        })->filter()->values();

        return response()->json([
            'role_permissions' => $intersectedPermissions,
            'message' => trans('api.list_of_all_available_records'),
        ]);
    }

    private function getSubPermissions($parent_id, $rolePermissions)
    {
        $permissions = Permission::where('parent_id', $parent_id)->get();

        if ($permissions->isEmpty()) {
            return [];
        }

        return $permissions->map(function ($permission) use ($rolePermissions) {
            $isIntersected = $rolePermissions->contains('id', $permission->id);

            $subPermissions = $this->getSubPermissions($permission->id, $rolePermissions);
            return [
                'id' => $permission->id,
                'name' => $permission->name,
                'name_ar' => $permission->name_ar,
                'is_intersected' => $isIntersected,
                'sub_permissions' => $subPermissions,
            ];
        })->all();
    }


}
