<?php

namespace App\Http\Resources\School;

use Illuminate\Http\Resources\Json\JsonResource;

class SchoolFacilitieResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'building_type'=> ($this->building_type)?$this->building_type:'',
            'building_status'=> ($this->building_status)?$this->building_status:'',
            'n_class'=> ($this->n_class > 0)?$this->n_class:'',
            'n_bathrooms'=> ($this->n_bathrooms)?$this->n_bathrooms:'',
            'n_floors'=> ($this->n_floors)?$this->n_floors:'',
            'n_team_rooms'=> ($this->n_team_rooms)?$this->n_team_rooms:'',
            'n_management_rooms'=>($this->n_management_rooms)? $this->n_management_rooms:'',
            'n_computer_laps'=> ($this->n_computer_laps)?$this->n_computer_laps:'',
            'n_science_laps'=> ($this->n_science_laps)?$this->n_science_laps:'',
            'n_ware_houses'=> ($this->n_ware_houses)?$this->n_ware_houses:'',
            'n_learning_resources'=> ($this->n_learning_resources)?$this->n_learning_resources:'',
            'n_activity_rooms'=> ($this->n_activity_rooms)?$this->n_activity_rooms:'',
            'n_meeting_rooms'=> ($this->n_meeting_rooms)?$this->n_meeting_rooms:'',
            'n_sport_houses'=> ($this->n_sport_houses)?$this->n_sport_houses:'',
            'n_theaters'=> ($this->n_theaters)?$this->n_theaters:'',
            'n_playgrouonds'=> ($this->n_playgrouonds)?$this->n_playgrouonds:'',
            'n_outdoors_court'=> ($this->n_outdoors_court)?$this->n_outdoors_court:'',
            'n_indoors_court'=>($this->n_indoors_court)?$this->n_indoors_court:''
        ];
    }
}
