<?php

namespace App\Http\Resources\Notification;

use App\Helpers\Helper;
use App\Models\Notification;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'body' => $this->body,
            'receptor' => $this->receptor,
            'scheduled' => $this->scheduled,
            'date_type' => __('api.' . $this->date_type),
            'date' => $this->date?Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'):null,
            'date_options' => $this->date?Helper::getDateOptions($this->date, $this->type):null,
            'time' => $this->time,
            'receptor_schools' => $this->receptors->map(function ($receptor) {
                return $receptor->school;
            }),
        ];
    }
}
