<?php

namespace App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings;

use Illuminate\Http\Resources\Json\JsonResource;

class TeamResource extends JsonResource
{
    protected $currentWork;
    protected $assigmentWorks;
    protected $includeCurrentWork;

    public function __construct($resource, $currentWork = null, $assigmentWorks = [], $includeCurrentWork = false)
    {
        parent::__construct($resource);
        $this->currentWork = $currentWork;
        $this->assigmentWorks = $assigmentWorks;  
        $this->includeCurrentWork = $includeCurrentWork;
    }

    public function toArray($request)
    {
        $response = [
            'id' => $this->id,
            'school_id' => $this->school_id,
            'name' => $this->name,
            'status' => ($this->status == 1) ? trans('api.active') : trans('api.inactive'),
            'namozeg_form_number' => $this->form_number,
            'assignment_form_number' => $this->assignment_form_number,
            'meetings' => $this->meetings,
            'assigmentWorks' => $this->assigmentWorks 
        ];

        // Include current work only if the flag is set
        if ($this->includeCurrentWork && $this->currentWork) {
            $response['Assignment_current_works'] = $this->currentWork->map(function ($work) {
                return [
                    'id' => $work->id,
                    'job_title' => $work->job_title,
                    'employees' => $work->employees->map(function ($employee) {
                        return [
                            'id' => $employee->id,
                            'name' => $employee->name,
                        ];
                    }),
                ];
            });
        }

        return $response;
    }
}
