<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use JWTAuth;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;

class ShiftScheduleWeekResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $checkIfCreated =  ShiftTeacher::where('school_id',$school->id)->where('school_employee_id','!=',NULL)->where('shift_schedule_id',$this->id)->first();
        $internalDaysSerials = [];
        if($checkIfCreated){
            $namazegVersionIds = ShiftTeacher::where('school_id',$school->id)->where('school_employee_id','!=',NULL)->where('shift_schedule_id',$this->id)->pluck('namazeg_version_id')->toArray();

            // Map each namazeg_version_id with a serial number
            $internalDaysSerials = collect($namazegVersionIds)->mapWithKeys(function ($namazegVersionId) {
                return [$namazegVersionId => NamazegVersion::find($namazegVersionId)->serial_number];
            });

        }

        return [
            'id'=>$this->id,
            'tilte'=>'جدول المناوبة الأسبوعي',
            'semester_name'=>$this->semester?->name,
            'week'=>$this->week?->name,
            'created_at'=>Carbon::parse($this->created_at)->format('d/m/Y'),
            'created_ststus'=>($checkIfCreated)? 'yes' :'no',

            'namazeg_version_id'=>$this->namazeg_version_id,
            'serial_number'=>$this->namozegVersion?->serial_number,
            'internalDaysSerials'=>$internalDaysSerials,

        ];
    }
}
