<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ShiftScheduleTeacherResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $teacherIds = explode(',',$this->school_employee_id);
        $teachers = SchoolEmployee::whereIn('id',$teacherIds)->pluck('name')->toArray();
        $teachers = implode(',',$teachers);

        $namazeg_version_ids = collect(explode(',', $this->namazeg_version_id));
        $mappedNamazegs = $namazeg_version_ids->map(function ($namazeg_version_id , $key) use ($teacherIds) {
            $teacher_id = isset($teacherIds[$key]) ? $teacherIds[$key] : null;
            return [
                'teacher_id' => $teacher_id,
                'namazeg_version_id,' => $namazeg_version_id,
                'serial_number' => NamazegVersion::find($namazeg_version_id)->serial_number,
            ];
        });

        return [
            'id'=>$this->id,
            'date'=>$this->day?->semesterWeekDay?->date,
            'day'=>$this->day?->semesterWeekDay?->day?->name,
            'teachers'=>$teachers,
            'teacher_ids'=>$teacherIds,
            'namazeg_teachers'=>$mappedNamazegs,
        ];
    }
}
