<?php

namespace App\Http\Resources\ManagerDashboard\Tables\Exams;

use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDay;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;


class TableExamResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Check if we're dealing with a collection or a single record
        $isCollection = $this instanceof AnonymousResourceCollection;
        if (!$isCollection){
            if($request->class_name_category){
                $tableExamDays =  TableExamDayResource::collection(TableExamDay::where('table_exam_id',$this->id)->where('class_id',$request->class_id)->where('class_name_category',$request->class_name_category)->get());
            }else{
                $tableExamDays =  TableExamDayResource::collection(TableExamDay::where('table_exam_id',$this->id)->where('class_id',$request->class_id)->where('class_name_id',$request->class_name_id)->get());
            }
        }else{
            $tableExamDays=[];
        }


        /** calss names and their ids*/
        $classNameIds = TableExamDay::where('table_exam_id',$this->id)->whereNotNull('class_name_id')->pluck('class_name_id')->unique()->toArray();
        $classNameNames = ClassName::whereIn('id',$classNameIds)->pluck('name')->toArray();
        $classNameCategories = TableExamDay::where('table_exam_id',$this->id)->whereNotNull('class_name_category')->pluck('class_name_category')->unique()->toArray();


        /** school calsses and their ids*/
        $schoolClassIds = TableExamDay::where('table_exam_id', $this->id)->whereNotNull('class_id')->pluck('class_id')->unique()->toArray();
        $schoolClasses = SchoolClass::whereIn('id', $schoolClassIds)->pluck('class_number')->toArray();

        if($request->table_exam_id){
            $classNameIds = ($request->class_name_id)?[$request->class_name_id]:[];
            $classNameNames = ClassName::where('id',$request->class_name_id)->pluck('name')->toArray();

            $schoolClassIds = [$request->class_id];
            $schoolClassIds = ($request->class_id)?SchoolClass::find($request->class_id)->class_number:'';
        }

        $tableExamNamazeg = TableExamNamazeg::where('table_exam_id', $this->id)->get();
        $tableExamNamazeg = $tableExamNamazeg->map(function ($tableExamNamozeg) {
            return [
                'serial_number' => $tableExamNamozeg->namozegVersion?->serial_number,
                'namazeg_id' => $tableExamNamozeg->namozegVersion?->namazeg_id
            ];
        });

        $data = [
            'id'=>$this->id,
            'title'=>$this->title,
            'exam_type'=>$this->exam_type,
            'exam_category'=>$this->exam_category,
            'table_type'=>$this->table_type,
            'start_date'=>$this->start_date,
            'leave_time'=>$this->leave_time,
            'semester_id'=>$this->semester?->id,
            'semester'=>$this->semester?->name,

            'class_name'=>implode(',',$classNameNames),
            'class_name_categories'=>$classNameCategories?$classNameCategories:NULL,
            'class_name_id'=>$classNameIds,
            'class_name_category'=>$request->class_name_category,


            'class'=>implode(',',$schoolClasses),
            'class_id'=>$schoolClassIds,

            'tableExamDays'=>$tableExamDays,
            'tableExamNamazeg'=>$tableExamNamazeg,
        ];
        return $data;

    }

}
