<?php

namespace App\Http\Resources\ManagerDashboard\Tables\Exams;

use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDay;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;


class TableExamNamazegResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $tableExam = TableExam::find($this->id);

        /** calss names and their ids*/
        $classNameIds =collect( TableExamDay::where('table_exam_id',$this->id)->whereNotNull('class_name_id')->pluck('class_name_id')->unique()->toArray());
        $classNameNames = ClassName::whereIn('id',$classNameIds)->pluck('name')->toArray();

        return $classNameIds->map(function ($classNameId){

            $className = ClassName::find($classNameId);

            /** school calsses and their ids*/
            $schoolClassId = TableExamDay::where('table_exam_id', $this->id)->where('class_name_id',$classNameId)->whereNotNull('class_id')->pluck('class_id')->unique()->toArray();

            $schoolClass = SchoolClass::whereIn('id',$schoolClassId)->first();

            $tableExamDays = TableExamDayResource::collection(TableExamDay::where('table_exam_id',$this->id)->where('class_name_id',$classNameId)->get());
            $data=[
                'class_name'=>$className->name,
                'school_class'=>$schoolClass? $schoolClass->class_number : '',
                'tableExamDays'=>$tableExamDays
            ];

            return $data;
        })->all();

    }
}
