<?php

namespace App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClassroomVisitResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        return [
            'id' => $this->id,
            'visiting_teacher_id' => $this->visitingTeacher->id,
            'visiting_teacher' => $this->visitingTeacher?->name,
            'visited_teacher_id' => $this->visitedTeacher?->id,
            'visited_teacher' => $this->visitedTeacher?->name,
            'period_id' => $this->period->id,
            'period' => $this->period->name,
            'subject_id' => $this->subject->id,
            'subject' => $this->subject->name,
            'school_class_id' => $this->class?->id,
            'class_id' => $this->class->className?->id,
            'class' => $this->class->className->name,
            'classNumber' => $this->class->class_number,
            'date_options' => Helper::getDateOptions($this->date, $this->date_type),
            
        ];
    }
}
