<?php

namespace App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SchoolAdminstrativeAbsentLateReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $school = School::findOrFail($this->school_id);

        $absentTeachersWithExcuse = SchoolEmployeeAttendance::where('school_id',$school->id)->where('type','teacher')->where('status','absent')->where('absence_reason','!=','without_excuse')->count();
        $absentTeachersWithOutExcuse = SchoolEmployeeAttendance::where('school_id',$school->id)->where('type','teacher')->where('status','absent')->where('absence_reason','without_excuse')->count();
        $absentDaysPerMonth = AbsentTeacherResource::collection(SchoolEmployee::where('school_id',$school->id)->where('type','teacher')->get() );

        $lateTeachersCount = SchoolEmployeeAttendance::where('school_id',$school->id)->where('type','teacher')->where('status','late')->count();
        $lateTeachers = LateTeacherResource::collection(SchoolEmployee::where('school_id',$school->id)->where('type','teacher')->get());

        $data =[
            'id'=>$this->id,
            'report_title'=>'تقارير غياب وتأخر للمعلمين',
            'report_category'=>trans("api.$this->report_category"),
            'date'=>$this->date,
            'date_type'=>$this->date_type,
            'report_created_at'=>$this->created_at->format('d/m/Y'),
            'namozeg_serial_number'=>$this->namozegVersion?->serial_number,
        ];

        if($this->report_category == 'late_teachers'){
            $data['late_count']=$lateTeachersCount;
            $data['total_late_minutes']=$this->totalLateMinutes($school->id);
            $data['late_teachers']=$lateTeachers;
        }

        if($this->report_category == 'absent_teachers'){
            $data['absent_with_excuse_count']=$absentTeachersWithExcuse;
            $data['absent_without_excuse_count']=$absentTeachersWithOutExcuse;
            $data['absent_days_per_month']=$absentDaysPerMonth;
        }

        return $data;
    }

    public function totalLateMinutes($schoolId){
        $teacherAttendances = SchoolEmployeeAttendance::where('school_id', $schoolId)
            ->where('status', 'late')
            ->get();
        $totalLateMinutes = 0;
        foreach ($teacherAttendances as $attendance) {
            $lateFrom = DateTime::createFromFormat('h:ia', $attendance->late_from_time);
            $lateTo = DateTime::createFromFormat('h:ia', $attendance->late_to_time);
            if ($lateFrom && $lateTo) {
                $difference = $lateFrom->diff($lateTo);
                $totalLateMinutes += ($difference->h * 60) + $difference->i;
            }
        }
        return $totalLateMinutes;
    }
}
