<?php

namespace App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;

class LateTeacherResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $lateWithExcuse = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','late')->where('late_reason','!=','')->count();
        $lateWithOutExcuse = SchoolEmployeeAttendance::where('school_employee_id',$this->id)->where('status','late')->where('late_reason','')->count();

        $teacherTotalLateMinutes = SchoolEmployeeAttendance::where('school_employee_id', $this->id)
            ->where('status', 'late')
            ->select(DB::raw('
                SUM(TIMESTAMPDIFF(MINUTE,
                    STR_TO_DATE(late_from_time, "%h:%i%p"),
                    STR_TO_DATE(late_to_time, "%h:%i%p")
                )) as total_late_time_in_minutes
            '))
            ->value('total_late_time_in_minutes');

       // dd($teacherTotalLateMinutes , $lateWithExcuse);

        return [
            'id'=>$this->id,
            'employee_name'=>$this->name,
            'ssn'=>$this->ssn,
            'late_with_excuse'=>$lateWithExcuse,
            'late_without_excuse'=>$lateWithOutExcuse,
            'teacher_total_late_minutes' => $this->totalLateMinutes($this->id),
        ];
    }

    public function totalLateMinutes($employee_id){
        $teacherAttendances = SchoolEmployeeAttendance::where('school_employee_id', $employee_id)
            ->where('status', 'late')
            ->get();
        $totalLateMinutes = 0;
        foreach ($teacherAttendances as $attendance) {
            $lateFrom = DateTime::createFromFormat('h:ia', $attendance->late_from_time);
            $lateTo = DateTime::createFromFormat('h:ia', $attendance->late_to_time);
            if ($lateFrom && $lateTo) {
                $difference = $lateFrom->diff($lateTo);
                $totalLateMinutes += ($difference->h * 60) + $difference->i;
            }
        }
        return $totalLateMinutes;
    }

}
