<?php

namespace App\Http\Resources\ManagerDashboard\NamazegPrint;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class NamazegCircularAttendanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        if($this->directed_to== "teachers"){
            $employess = SchoolEmployee::where('type','teacher')->where('school_id',$this->school_id)->pluck('name')->toArray();
        }elseif($this->directed_to == "adminstrators"){
            $employess = SchoolEmployee::where('type', 'adminstrative')->where('school_id',$this->school_id)->pluck('name')->toArray();
        }elseif($this->directed_to == "teachers_adminstrators"){
            $employess = SchoolEmployee::where('school_id',$this->school_id)->pluck('name')->toArray();
        }
        return [
            'id' => $this->id,
            'form_number' => $this->namozegVersion->namozeg->form_number,
            'serial_number' => $this->namozegVersion->serial_number,
            'employee' => $employess,
            'issued_by' => $this->issued_by,
            'about' => $this->about,
            'date' =>  $this->date,
        ];
    }
}
