<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class TransferQuranResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'student_name' => $this->student->name,
            'nationality' => $this->student->nationality,
            'class_name' => $this->student->schoolClass?->className->name,
            'serial_number' => $this->namozegVersion->serial_number,
            'trans_form' => $this->trans_form,
            'trans_to' => $this->trans_to,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar')
        ];
    }
}
