<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class SchoolCommitmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion->serial_number,
            'student' => $this->student?->name,
            'class_name' => $this->student->schoolClass?->className->name,
            'class_number' => $this->student->schoolClass?->class_number,
            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar'),
        ];
    }
}
