<?php

namespace App\Http\Resources\ManagerDashboard\Namazeg;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class EvacuationimagesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name'=>$this->id.'تقرير خطة الاخلاء رقم  ',
            'serial_number' => $this->namozegVersion->serial_number,
            'n_students' => $this->n_students,
            'n_employees' => $this->n_employees,
            'safety_man' => $this->safety_man,
            'duration' => $this->duration,
            'images' => $this->images->map(function($image){
                return ["id"=>$image->id,"image"=>Helper::uploadedImagesPath('evacuationNamozeg', $image->image)];
            }),

            'created_at' =>  $this->created_at->translatedFormat('d F Y', 'ar')
        ];
    }
}
