<?php

namespace App\Http\Resources\ManagerDashboard\Exams\StudentCommittes;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

use function PHPUnit\Framework\isEmpty;

class CommitteeDataResourceOld extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
      
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'school_id' => $this->school_id,
            'semester_id' => $this->semester_id,
            'name' => $this->name,
            'location' => $this->CommitteeData->first()->location ?? $this->name,
            'columns_numbers' =>  count($this->CommitteeData) ?? 1,
            'schoolclass_id' => $this->schoolclass_id,
            'students_number' => $this->CommitteeStudents->count(),
            'students' => $this->CommitteeData->isNotEmpty()
                ? $this->CommitteeData->flatMap(function ($committeeData) {
                    $studentIds = json_decode($committeeData->student_ids) ?? []; // Default to empty array if null
                    $students = $this->CommitteeStudents->whereIn('student_id', $studentIds);

                    return $students->map(function ($CommitteeStudent) use ($committeeData) {
                        return [
                            'id' => $CommitteeStudent->student_id,
                            'name' => $CommitteeStudent->student->name,
                            'class_name' => $committeeData->SchoolClass->className->name ?? null,
                            'class_number' => $committeeData->SchoolClass->class_number ?? null,
                            'seating_number' => $CommitteeStudent->seat_number,
                        ];
                    });
                })
                : $this->CommitteeStudents->map(function ($student_committee_seating_number) {
                    
                    return [
                        'id' =>$student_committee_seating_number->student->id,
                        'name' => $student_committee_seating_number->student->name,
                        'class_name' => $this->SchoolClass?->className?->name,
                        'class_number' => $this->SchoolClass?->class_number,
                        'seating_number' => $student_committee_seating_number->seat_number,
                    ];
                }),
            'committee_sheet' =>  $this->CommitteeData->isNotEmpty() ? $this->CommitteeData->map(function ($committeeData) {
                return [
                    'class_name' => $committeeData->SchoolClass ? $committeeData->SchoolClass->className->name : null,
                    'class_number' => $committeeData->SchoolClass ? $committeeData->SchoolClass->class_number : null,
                    'student_count' => count(json_decode($committeeData->student_ids)),
                ];
            }) : [
                'class_name' => $this->SchoolClass?->className?->name,
                'class_number' => $this->SchoolClass?->class_number,
            ],

            'committee_plan' => $this->CommitteeData->map(function ($committeeData) {
                // Get the student IDs for this committee data
                $studentIds = json_decode($committeeData->student_ids);
                // Find corresponding students based on the student_ids
                $students = $this->CommitteeStudents->whereIn('student_id', $studentIds);

                return [
                    'class_name' => $committeeData->SchoolClass ? $committeeData->SchoolClass->className->name : null,
                    'class_number' => $committeeData->SchoolClass ? $committeeData->SchoolClass->class_number : null,
                    'Number of seats' => count($students),
                    'students' => $students->map(function ($CommitteeStudent) {
                        return [
                            'id' => $CommitteeStudent->student_id,
                            'name' => $CommitteeStudent->student->name,
                            'seating_number' => $CommitteeStudent->seat_number,
                        ];
                    })->values(), // Use values() to reindex the array numerically
                ];
            }),

        ];
    }
}
