<?php

namespace App\Http\Resources\ManagerDashboard\Exams\StudentCommittes;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClassResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,  
            'school_classes' => $this->schoolClasses->map(function ($class) {
               
                return [
                    'school' => $class->school_id,
                    'school_class_id' => $class->id,
                    'class_number' => $class->class_number,
                    
                   
                ];
            }),
        ];
    }
}
