<?php

namespace App\Http\Resources\ManagerDashboard\Exams\NamazegPlans;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MonitorDistribtionAssignmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'serial_number' => $this->namozegVersion?->serial_number,
            'school_id' => $this->school_id,
            'semester_id' => $this->semester_id,
            'employees' => $this->monitors ? $this->monitors->map(function ($monitor) {
                return [
                    'employee_id' => $monitor->employee_id,
                    'name' => $monitor->employee->name,
                    'period' => json_decode($monitor->period),
                    'date' => Carbon::createFromFormat('d/m/Y', $monitor->date)->format('d/m/Y'),
                    'date_options' => Helper::getDateOptions($monitor->date, $monitor->type),
                    'created_at' =>  $monitor->created_at->translatedFormat('d F Y', 'ar'),

                ];
            }) : []
        ];
    }
}
