<?php

namespace App\Http\Resources\ManagerDashboard\Circulars;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentGeneralCircularResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=> $this->id,
            'type'=> 'StudentCirculars',
            'serial_number'=> $this?->namozegVersion?->serial_number,
            'directed_to'=> $this->directed_to,
            'class_name_id'=> $this->class_name_id,
            'class_name'=> $this?->class_name?->name,
            'class_number'=> $this->class_number,
            'school_id' => $this->school_id,
            'school_name' => $this->school->name,
            'title' => $this->title,
            'created_at' => $this->created_at,
        ];
    }
}
