<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use App\Models\AdminDashboard\School\SchoolSemester;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CommitteeAssignmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'committee_id' => $this->id,
            'name' => $this->name,
            'school_id' => $this->school_id,
            'assignment_form_number' => $this->assignment_form_number,
            'assignment' => $this->assignment ? [
                'assignment_id' => $this->assignment->id,
                'school_id' => $this->assignment->school_id,
                'namozeg_serial_number' => $this->assignment->namozegVersion->serial_number,
                'assignment_date' => Carbon::createFromFormat('d/m/Y', $this->assignment->date)->format('d/m/Y'),
                'date_options' => Helper::getDateOptions($this->assignment->date, $this->assignment->type),
                'members' => $this->members
                    ? $this->members->filter(function ($member) {
                        return $member->assignment_committee_id == $this->assignment->id;
                    })->map(function ($member) {
                        return [
                            'employee_id' => $member->employee_id,
                            'employee_name' => $member->employee->name,
                            'assignment_work' => $member->assignment_work,
                            'mission' => $member->mission
                        ];
                    })->values() // Reset the keys here
                    : [],
                'tasks' => $this->tasks->select('id','task_name'),
                'meetings' => $this->meetings
                    ? $this->meetings->filter(function ($meeting) {
                        // Filter meetings by type (e.g., 'دوري')
                        return $meeting->meeting_type == 'دوري';
                    })->groupBy('semester_id') // Group meetings by semester_id
                    ->map(function ($meetings, $semesterId) {
                        $semester_name = SchoolSemester::find($semesterId)->name;
                        return [
                            'semester_id' => $semesterId,
                            'semester_name' => $semester_name,
                            'meetings' => $meetings->map(function ($meeting) {
                                return new MeetingResource($meeting); // Transform each meeting using MeetingResource
                            })
                        ];
                    })->values() // Reset keys to start from 0
                    : []
            ] : [],
        ];
    }
}
