<?php

namespace App\Http\Resources\ManagerDashboard\Assignments;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use App\Models\AdminDashboard\School\SchoolSemester;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AssignmentTeamDetails extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
      
        return [
            'assignment_id' => $this->id,
            'school_id' => $this->school_id,
            'namozeg_serial_number' => $this->namozegVersion->serial_number,
            'assignment_date' => Carbon::createFromFormat('d/m/Y', $this->date)->format('d/m/Y'),
            'date_options' => Helper::getDateOptions($this->date, $this->type),
            'members' => $this->teamMembers
                ? $this->teamMembers->map(function ($member) {
                    return [
                        'assignment_member' => $member->id,
                        'employee_id' => $member->employee_id,
                        'employee_name' => $member->employee->name,
                        'assignment_work' => $member->assignment_work,
                        'mission' => $member->mission
                    ];
                })->values() // Reset the keys here
                : [],
            'tasks' => $this->team->tasks?->select('id','task_name'),
            'meetings' => $this->team->meetings
                ? $this->team->meetings->filter(function ($meeting) {
                    // Filter meetings by type (e.g., 'دوري')
                    return $meeting->meeting_type == 'دوري' && $meeting->school_id = $this->school_id;
                })->groupBy('semester_id') // Group meetings by semester_id
                ->map(function ($meetings, $semesterId) {
                    $semester_name = SchoolSemester::find($semesterId)->name;
                    return [
                        'semester_id' => $semesterId,
                        'semester_name' => $semester_name,
                        'meetings' => $meetings->map(function ($meeting) {
                            return new MeetingResource($meeting); // Transform each meeting using MeetingResource
                        })
                    ];
                })->values() // Reset keys to start from 0
                : []
            ];
    }
}
