<?php

namespace App\Http\Resources\ManagerDashboard\AbsenseAndLateness;

use Illuminate\Http\Resources\Json\JsonResource;

class StudentLatenessProcedureResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        if($request->status && $request->status == 'done') {
            $procedures = $this->mainProcedures()->where('status','done')->get();
        } else {
            $procedures = $this->mainProcedures;
        }
        return [
            'id'=> $this->id,
            'student_id'=> $this->student_id,
            'student_name'=> $this->student->name,
            'class_name'=> $this->student->schoolClass?->className?->name,
            'namozeg_serial_number'=> $this->namozegVersion->serial_number,
            'warning'=> $this->warning,
            'lateness_days'=>$this->lateness_days,
            'creation_date'=>$this->created_at,
            'procedures'=> $procedures,
        ];
    }
}
