<?php

namespace App\Http\Requests\Violation;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ViolationTitleStoreNextRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return [
            '*.id' => 'required|integer|exists:violation_titles,id', 
            '*.custom_name' => 'required|string',
            '*.violation_punishment_ids' => 'required|array',     
            '*.other_punishment_ids' => 'nullable|array|exists:namazeg,id'
        ];        
    }
    

}
