<?php

namespace App\Http\Requests\School;

use App\Helpers\Helper;
use App\Models\SchoolSemester;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class GuideRegulationFileStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'guide_regulation_id' => 'required|exists:guides_and_regulations,id',
            'publish_date' => 'required',
            'publish_date_type' => 'required|in:hijri,coptic',
            'file_name' => 'required|string|max:100',
            'guide_regulation_file' => 'required|mimes:pdf',
        ];
    }

    protected function prepareForValidation()
    {
        $publish_date = $this->publish_date;
        if (isset($this->publish_date_type) && isset($this->publish_date) && $this->publish_date_type == "hijri") {
            $publish_date = Helper::getCoptic($this->publish_date);
        }

        $this->merge([
            'publish_date' => \Carbon\Carbon::createFromFormat('d/m/Y', $publish_date)->format('Y-m-d'),
        ]);
    }

}
