<?php

namespace App\Http\Requests\ManagerDashboard\waitingPeriodsSchedule;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class WaitingPeriodsScheduleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        
        $start_date = \Carbon\Carbon::createFromFormat('d/m/Y', $request->semester->start_date)->format('Y-m-d');
        $end_date = \Carbon\Carbon::createFromFormat('d/m/Y', $request->semester->end_date)->format('Y-m-d');
        return [
            'school_employee_id' => 'required|integer|exists:school_employees,id',          
            'school_id' => 'required|integer|exists:schools,id',          
            'semester_id' => 'required|integer|exists:semesters,id',          
            'creation_date' => [
                "required",
                "after_or_equal:$start_date",
                "before_or_equal:$end_date",
            ]
        ];
    }
        /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation()
    {
        $semester = Helper::getCurrentSchoolSemester($this->creation_date);
        $creation_date = $this->creation_date;
        if (isset($this->creation_date_type) && isset($this->creation_date)) {
            if ($this->creation_date_type == "hijri") {
                $creation_date = Helper::getCoptic($this->creation_date);
            }
        }

        $this->merge([
            'creation_date' => \Carbon\Carbon::createFromFormat('d/m/Y', $creation_date)->format('Y-m-d'),
            'semester' => $semester,
        ]);
    }
}
