<?php

namespace App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class UpdateTeamRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return[
            'school_id' => 'exists:schools,id',
            'name' => 'string|max:150',
            'form_number' => 'nullable|unique:teams,form_number|exists:namazeg,form_number',
            'assignment_form_number' => 'nullable|unique:teams,form_number|exists:namazeg,form_number',
            'status' =>['in:1,0'],
        ];
    }

}
