<?php

namespace App\Http\Requests\ManagerDashboard\Setting\BankTransfer;

use Illuminate\Foundation\Http\FormRequest;

class StoreBankTransferDataRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'bank_account_id' => ['required', 'exists:bank_accounts,id'],
            'transfer_date' => ['required', 'string'],
            'transfer_receipt' => ['required', 'mimes:png,jpg,jpeg'],
            'date_type' => ['required', 'in:coptic,hijri'],
        ];
    }
}
