<?php

namespace App\Http\Requests\ManagerDashboard\Proceed;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ProceedUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return[
            'title' => 'string',
            'text' => 'string',
            'date' => [ 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'string|in:coptic,hijri',
            'proceed_type' => 'string|in:destruction,loss,incident,general',
        ];
        
    }

}
