<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg\Violations;

use Illuminate\Foundation\Http\FormRequest;

class NamazegIncidentProceedRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'type' => 'required|array',
            'type.*' => 'required|string|in:images,videos,speeches',
            'other_type' => 'nullable|string',
            'location' => 'required|string',
            'witnesses' => 'required|array',
            'witnesses.*.employee_id' => 'required|exists:school_employees,id',
            'witnesses.*.his_work' => 'required|string',

        ];
    }
}

