<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class MaintenanceFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'is_urgent' => 'required|in:1,0',
            'date_type_prefered' => 'required|in:am,am_pm',
            'maintenance_type' => 'required|array',
            'maintenance_type.*' => 'required|in:electric,wood,water,cooling,aircondition,chairs_tables',
            'other_type' => 'nullable|string',
            'maintenance_desc' => 'required|array',
            'maintenance_desc.*' => 'required|string',
        ];
        return $rules;
    }
}
