<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class AssignProfessionalCommunitiesUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'date' => ['string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'in:hijri,coptic',
            'start_date' => 'string',
            'start_date_type' => 'in:hijri,coptic',
            'specialize_id' => 'string|exists:specializations,id',
            'data' => 'array',
            'data.*.employee_id' => 'exists:school_employees,id',
            'data.*.assignment_details' => 'string',
            'data.*.class_teaching' => 'string',
        ];
        return $rules;
    }
}
