<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class AbsenceQuestioningStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'employee_id' => 'required|exists:school_employees,id',
            'absence_date' => ['required', 'string', new DateWithinSemester($request->input('absence_date_type'))],
            'absence_date_type' => 'required|in:coptic,hijri',
            'attendance_date' => ['required', 'string', new DateWithinSemester($request->input('attendance_date_type'))],
            'attendance_date_type' => 'required|in:coptic,hijri',
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|in:coptic,hijri',
        ];
        return $rules;
    }
}
