<?php

namespace App\Http\Requests\ManagerDashboard\LettersAndAlarts;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class StoreAlertRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'type' => ['required','in:verbal,written'],
            'date_type' => ['required','in:hijri,coptic'],
            'date' => ['required', 'date_format:d/m/Y',new DateWithinSemester($request->input('date_type'))],
            'alert_direct_to' => ['required','exists:school_employees,id'],
            'notes' => ['required','array'],
         
        ];

    }

}
