<?php

namespace App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees;

use Illuminate\Foundation\Http\FormRequest;

class CorrectionAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'subject_id'  => ['required', 'exists:subjects,id'],
            'location' => ['required'],
            'round' => ['required','in:الأول,الثاني'],
            'members'=> ['required', 'array'],
            'members.*.employee_id' => ['required', 'exists:school_employees,id'], 
            'members.*.assignment_work' => ['required', 'string'],  
            'members.*.mission' => ['nullable', 'string'],  
       
        ];
    }
}
