<?php

namespace App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDistribtionAssignment;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDistribtionAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'data' => ['required', 'array'],
            'data.semester_id' => ['nullable', 'exists:semesters,id'],
            'data.employees' => ['nullable', 'array'],
            'data.employees.*.employee_id' => ['nullable', 'exists:school_employees,id'],
            'data.employees.*.date' => ['nullable'],
            'data.employees.*.date_type' => ['nullable', 'string', 'in:coptic,hijri'],
            'data.employees.*.period.*' => ['required', 'string', 'in:الاولى,الثانية'],
        ];
    }
}
