<?php

namespace App\Http\Requests\ManagerDashboard\Assignments;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class StoreAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'current_work_id' => ['required','exists:current_works,id'],
            'date' => ['required', 'date_format:d/m/Y', new DateWithinSemester($request->input('date_type'))],
            'date_type' => ['in:coptic,hijri'],
            'employees'=>['required','array'],
            'employees.*'=> ['integer','exists:school_employees,id']
        ];
    }
}
