<?php

namespace App\Http\Requests\ManagerDashboard\Assignments;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class AssignmentTeamRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'assignment.date' => ['required',new DateWithinSemester($request->input('assignment.date_type'))],
            'assignment.date_type' => 'required|string|in:coptic,hijri',
            
            'team_members' => 'required|array|min:1',
            'team_members.*.employee_id' => 'required|integer|exists:school_employees,id',
           
            'team_members.*.assignment_work' => [
                'required',
                Rule::in(['رئيساً للفريق','مقرر الفريق', 'عضو']),
            ],
            'team_semesters_meetings' => 'required|array|min:1',
            'team_semesters_meetings.*.semester_id' => 'required|integer|exists:semesters,id',
            'team_semesters_meetings.*.meetings' => 'required|array|min:1',
            'team_semesters_meetings.*.meetings.*.name' => 'required|string',
            'team_semesters_meetings.*.meetings.*.date' => 'required|date_format:d/m/Y',
            'team_semesters_meetings.*.meetings.*.date_type' => 'required|string|in:coptic,hijri',
            'team_semesters_meetings.*.meetings.*.place' => 'nullable|string',

            'tasks' => ['nullable','array'],
            'tasks.*' => ['nullable','string'],
        ];
    }

    protected function withValidator($validator)
    {
        $validator->after(function ($validator) {
            $members = $this->input('team_members');
            $roles = ['رئيساً للفريق', 'مقرر الفريق'];

            foreach ($roles as $role) {
                $count = collect($members)->where('assignment_work', $role)->count();

                // Fail validation if the role appears more than once
                if ($count > 1) {
                    $validator->errors()->add('team_members', "لا يمكن اخيار هذا العمل المكلف به ({$role}) اكثر من مره واحده");
                }
            }
        });
    }
}
