<?php

namespace App\Http\Requests\Event;

use App\Rules\DateWithinSemester;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class EventStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return[
            'date_from' => ['required', 'string', 'date_format:d/m/Y', new DateWithinSemester($request->input('date_from_type'))],
            'date_from_type' => 'required|string|in:coptic,hijri',
            'date_to' => ['required', 'string', 'date_format:d/m/Y', new DateWithinSemester($request->input('date_to_type'))],
            'date_to_type' => 'required|string|in:coptic,hijri',
            'title' => 'required|max:40'
        ];
        
        
    }
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->date_from && $this->date_to) {
                $dateFrom = Carbon::createFromFormat('d/m/Y', $this->date_from);
                $dateTo = Carbon::createFromFormat('d/m/Y', $this->date_to);

                if ($dateTo<$dateFrom) {
                    $validator->errors()->add('date_to', 'The date to must be a date after the date from.');
                }
            }
        });
    }

}

