<?php

namespace App\Http\Requests\AdminDashboard\Categories;

use Illuminate\Foundation\Http\FormRequest;

class StoreCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'parent_id' => 'nullable|exists:categories,id',
            'board_type' => 'required|in:teacher,manager',
            'page_url' => 'required|string|max:255',
            'status' => 'required|in:0,1',
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'يجب أن يكون الاسم نصًا.',
            'name.max' => 'الاسم يجب ألا يتجاوز 255 حرفًا.',
            'parent_id.exists' => 'القسم الرئيسي المحدد غير صالح.',
            'board_type.required' => 'حقل نوع اللوحة مطلوب.',
            'board_type.in' => 'القيمة المحددة لنوع اللوحة غير صالحة.',
            'page_url.required' => 'حقل رابط الصفحة مطلوب.',
            'page_url.string' => 'يجب أن يكون رابط الصفحة نصًا.',
            'page_url.max' => 'رابط الصفحة يجب ألا يتجاوز 255 حرفًا.',
            'status.required' => 'حقل الحالة مطلوب.',
            'status.in' => 'القيمة المحددة للحالة غير صالحة.',
        ];
    }
}
