<?php

namespace App\Http\Middleware;

use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Auth;

class UpdateLastSeen
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);
        if ($response instanceof BinaryFileResponse) {
        // Check if the response is successful (status 200) and the user is authenticated
        if (Auth::check() && $response->status() === 200 && !($response instanceof BinaryFileResponse || $response instanceof StreamedResponse)){

            $user = Auth::user()->fresh();
            $user->last_seen = Carbon::now();
            $user->save();
        }
        }

        return $response;
    }
}
