<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Illuminate\Auth\Events\Verified;
use App\Models\User;

use Mail;

class EmailVerificationController extends Controller
{
    // Send verification email
    public function sendVerificationEmail(Request $request)
    {
        $user = $request->user();

        if ($user->hasVerifiedEmail()) {
            return response()->json(['message' => trans('api.Email is already verified.')], 400);
        }

        $verificationUrl = URL::temporarySignedRoute(
            'verification.verify',
            now()->addMinutes(30),
            ['id' => $user->id, 'hash' => sha1($user->email)]
        );

        // Send email (use a mailer or notification)
        $data = ['verificationUrl' => $verificationUrl];

        Mail::send('emails/email-verification', $data, function($msg) use ($user) {
            $msg->to($user->email, 'Laam App')->subject('Email Verification');
            $msg->from(config('mail.from.address'), config('mail.from.name'));
        });

        return response()->json(['verification_url'=>$verificationUrl , 'message' => trans('api.Verification link sent.')]);
    }

    // Verify email
    public function verify(Request $request, $id, $hash)
    {
        $user = User::findOrFail($id);

        if (!hash_equals((string) $hash, sha1($user->email))) {

            $htmlResponse =  "<!DOCTYPE html> <html lang='ar'> <head> <meta charset='UTF-8'> <title>فشل التحقق من البريد الإلكتروني</title> </head> <body style='text-align: right; direction: rtl; font-family: Arial, sans-serif;'> <h1>فشل التحقق من البريد الإلكتروني</h1> <p>رابط التحقق غير صالح أو انتهت صلاحيته.</p> <p>يرجى طلب رابط تحقق جديد من نظام <strong>لام</strong>.</p> </body> </html>";
            return response($htmlResponse)->header('Content-Type', 'text/html');
        }

        if ($user->hasVerifiedEmail()) {
            return response()->json(['message' => trans('api.Email is already verified.')]);
        }

        /** mark user email is verfied  **/
        $user->markEmailAsVerified();

        /** send user welcome email  **/
        Mail::send('emails/welcome-email', [],function($msg) use ($user) {
            $msg->to($user->email, 'Laam App')->subject('Thanks For Using Laam');
            $msg->from(config('mail.from.address'), config('mail.from.name'));
        });


        $htmlResponse =  "<!DOCTYPE html> <html lang='ar'> <head> <meta charset='UTF-8'> <title>تم التحقق من البريد الإلكتروني</title> </head> <body style='text-align: right; direction: rtl; font-family: Arial, sans-serif;'> <h1>تم التحقق من البريد الإلكتروني بنجاح!</h1> <p>شكراً لتفعيل بريدك الإلكتروني في نظام <strong>لام</strong>.</p> <p>سيتم إغلاق هذه النافذة تلقائياً.</p> <script> setTimeout(() => { window.close(); }, 2000); </script> </body> </html>";
        return response($htmlResponse)->header('Content-Type', 'text/html');
    }

    // Check if email is verified
    public function isVerified(Request $request)
    {
        $user = $request->user();

        return response()->json(['is_verified' => $user->hasVerifiedEmail()]);
    }
}
